/*
 * Decompiled with CFR 0.152.
 */
package ca.teamdman.sfm.common.net;

import ca.teamdman.sfm.SFM;
import ca.teamdman.sfm.client.screen.SFMScreenChangeHelpers;
import ca.teamdman.sfm.client.screen.TomlEditScreenOpenContext;
import ca.teamdman.sfm.common.command.ConfigCommandBehaviourInput;
import ca.teamdman.sfm.common.config.SFMConfig;
import ca.teamdman.sfm.common.config.SFMConfigReadWriter;
import ca.teamdman.sfm.common.net.SFMPacket;
import ca.teamdman.sfm.common.net.SFMPacketDaddy;
import ca.teamdman.sfm.common.net.SFMPacketHandlingContext;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;

public record ClientboundClientConfigCommandPacket(ConfigCommandBehaviourInput requestingEditMode) implements SFMPacket
{

    public static class Daddy
    implements SFMPacketDaddy<ClientboundClientConfigCommandPacket> {
        @Override
        public SFMPacketDaddy.PacketDirection getPacketDirection() {
            return SFMPacketDaddy.PacketDirection.CLIENTBOUND;
        }

        @Override
        public void encode(ClientboundClientConfigCommandPacket msg, RegistryFriendlyByteBuf friendlyByteBuf) {
            friendlyByteBuf.writeEnum((Enum)msg.requestingEditMode());
        }

        @Override
        public ClientboundClientConfigCommandPacket decode(RegistryFriendlyByteBuf friendlyByteBuf) {
            return new ClientboundClientConfigCommandPacket((ConfigCommandBehaviourInput)friendlyByteBuf.readEnum(ConfigCommandBehaviourInput.class));
        }

        @Override
        public void handle(ClientboundClientConfigCommandPacket msg, SFMPacketHandlingContext context) {
            String configTomlString = SFMConfigReadWriter.getConfigToml(SFMConfig.CLIENT_CONFIG_SPEC);
            if (configTomlString == null) {
                SFM.LOGGER.error("Unable to get client config");
                return;
            }
            configTomlString = configTomlString.replaceAll("\r", "");
            switch (msg.requestingEditMode()) {
                case SHOW: {
                    SFMScreenChangeHelpers.showTomlEditScreen(new TomlEditScreenOpenContext(configTomlString, $ -> {}));
                    break;
                }
                case EDIT: {
                    SFMScreenChangeHelpers.showTomlEditScreen(new TomlEditScreenOpenContext(configTomlString, Daddy::handleNewClientConfig));
                }
            }
        }

        @Override
        public Class<ClientboundClientConfigCommandPacket> getPacketClass() {
            return ClientboundClientConfigCommandPacket.class;
        }

        public static void handleNewClientConfig(String newConfigToml) {
            SFMConfigReadWriter.ConfigSyncResult configSyncResult = SFMConfigReadWriter.updateClientConfig(newConfigToml);
            LocalPlayer player = Minecraft.getInstance().player;
            if (player != null) {
                player.sendSystemMessage((Component)configSyncResult.component());
            }
        }
    }
}

